CLS
PRINT "    ************************************************************************"
PRINT "    **                                                                    **"
PRINT "    **                         A M D A S C O N                            **"
PRINT "    **                                                                    **"
PRINT "    ** Interpolates (sic!) monthly AMDASS data to PS123 format.           **"
PRINT "    **                                                                    **"
PRINT "    ** NOTE that this file (AMDASCON.EXE) and the AMDASS files STATIONS,  **"
PRINT "    ** PAR01, PAR02, PAR03, PAR04, PAR05, PAR07 and PAR08 must be in the  **"
PRINT "    ** same directory.                              (May 1994)            **"
PRINT "    ************************************************************************"
PRINT
'
DIM MONTH(12), TMAX(12), TMIN(12), PREC(12), RHA(12), u(12), SUNH(12)
DIM TMEAN(12), VPA(12), SVAP(12), DL(12), E0(12), ET0(12), LOM(12)
DIM GTMAX(365), GTMIN(365), GPREC(365), GRHA(365), GE0(365), GSUNH(365)
DIM GET0(365)
DEF FNASN (x) = ATN(x / SQR(1 - x ^ 2))
'
' ** Declaration of Constants and functions **
'
PI = 3.14159
RAD = PI / 180
PSYCHRO = .000662 ' psychrometric constant in 1/C
REFLWATER = .05 ' reflection coefficient of water surface
REFLCROP = .25 ' reflection coefficient of crop surface
LATHEAT = 2.45 * 10 ^ 6 ' latent heat of evaporation in J/kg = J/mm
BOLTZ = .0049  ' Boltzmann constant in J/m2/d/K4
SC = 1353 ' solar constant in J/m2/s
'
' ** Collect raw data from file **
'
INPUT "    SPECIFY THE RECORD NUMBER OF THE SITE: "; STNR
PRINT
'
' The length of all months is stored in array LOM(12).
'
        FOR MONTH = 1 TO 12
                IF MONTH = 4 OR MONTH = 6 OR MONTH = 9 OR MONTH = 11 THEN
                        LOM = 30
                ELSEIF MONTH = 2 THEN
                        LOM = 28
                ELSE
                        LOM = 31
                END IF
                LOM(MONTH) = LOM
        NEXT MONTH
        '
'
OPEN "STATIONS" FOR INPUT AS #1
        INPUT #1, STNO, DUMMY1$, LAT, LON, ELEVATION, SITELABEL$
        IF STNO <> STNR THEN
                WHILE NOT EOF(1) AND STNR <> STNO
                        INPUT #1, STNO, DUMMY1$, LAT, LON, ELEVATION, SITELABEL$
                WEND
        END IF
CLOSE #1
IF STNO = -999 THEN
        INPUT "RECORD NUMBER NOT IN STATIONS FILE!  CONTINUE (Y/N)"; FIRSTLINE$
        IF FIRSTLINE$ = "n" OR FIRSTLINE$ = "N" THEN END
ELSE
        PRINT SITELABEL$; ","; LAT; ","; LON; ","; ELEVATION
END IF
'
OPEN "PAR03" FOR INPUT AS #1
INPUT #1, STNO, DUMMY1, DUMMY2, DUMMY3, TMAX(1), TMAX(2), TMAX(3), TMAX(4), TMAX(5), TMAX(6), TMAX(7), TMAX(8), TMAX(9), TMAX(10), TMAX(11), TMAX(12), DUMMY4, DUMMY2$
        IF STNO <> STNR THEN
                WHILE NOT EOF(1) AND STNR <> STNO
                        INPUT #1, STNO, DUMMY1, DUMMY2, DUMMY3, TMAX(1), TMAX(2), TMAX(3), TMAX(4), TMAX(5), TMAX(6), TMAX(7), TMAX(8), TMAX(9), TMAX(10), TMAX(11), TMAX(12), DUMMY4, DUMMY2$
                WEND
        END IF
CLOSE #1
IF STNO = -999 THEN
        INPUT "RECORD NUMBER NOT IN FILE PAR03 (TMAX in oC)!  CONTINUE (Y/N)"; TMAXMIS$
        IF TMAXMIS$ = "n" OR TMAXMIS$ = "N" THEN END
ELSE
        PRINT "TMAX:";
        FOR x = 1 TO 12
                PRINT USING "###.##"; TMAX(x);
        NEXT x
END IF
'
OPEN "PAR04" FOR INPUT AS #1
INPUT #1, STNO, DUMMY1, DUMMY2, DUMMY3, TMIN(1), TMIN(2), TMIN(3), TMIN(4), TMIN(5), TMIN(6), TMIN(7), TMIN(8), TMIN(9), TMIN(10), TMIN(11), TMIN(12), DUMMY4, DUMMY2$
        IF STNO <> STNR THEN
                WHILE NOT EOF(1) AND STNR <> STNO
                        INPUT #1, STNO, DUMMY1, DUMMY2, DUMMY3, TMIN(1), TMIN(2), TMIN(3), TMIN(4), TMIN(5), TMIN(6), TMIN(7), TMIN(8), TMIN(9), TMIN(10), TMIN(11), TMIN(12), DUMMY4, DUMMY2$
                WEND
        END IF
CLOSE #1
IF STNO = -999 THEN
        INPUT "RECORD NUMBER NOT IN FILE PAR04 (TMIN in oC)!  CONTINUE (Y/N)"; TMINMIS$
        IF TMINMIS$ = "n" OR TMINMIS$ = "N" THEN END
ELSE
        PRINT "TMIN:";
        FOR x = 1 TO 12
                PRINT USING "###.##"; TMIN(x);
        NEXT x
END IF
'
OPEN "PAR01" FOR INPUT AS #1
INPUT #1, STNO, DUMMY1, DUMMY2, DUMMY3, PREC(1), PREC(2), PREC(3), PREC(4), PREC(5), PREC(6), PREC(7), PREC(8), PREC(9), PREC(10), PREC(11), PREC(12), DUMMY4, DUMMY2$
        IF STNO <> STNR THEN
                WHILE NOT EOF(1) AND STNR <> STNO
                        INPUT #1, STNO, DUMMY1, DUMMY2, DUMMY3, PREC(1), PREC(2), PREC(3), PREC(4), PREC(5), PREC(6), PREC(7), PREC(8), PREC(9), PREC(10), PREC(11), PREC(12), DUMMY4, DUMMY2$
                WEND
        END IF
CLOSE #1
IF STNO = -999 THEN
        INPUT "RECORD NUMBER NOT IN FILE PAR01 (PREC in mm/month)!  CONTINUE (Y/N)"; PRECMIS$
        IF PRECMIS$ = "n" OR PRECMIS$ = "N" THEN END
ELSE
        PRINT "PREC:";
        FOR x = 1 TO 12
                PREC(x) = PREC(x) / 10
                PRINT USING "###.##"; PREC(x);
        NEXT x
END IF
'
OPEN "PAR05" FOR INPUT AS #1
INPUT #1, STNO, DUMMY1, DUMMY2, DUMMY3, VPA(1), VPA(2), VPA(3), VPA(4), VPA(5), VPA(6), VPA(7), VPA(8), VPA(9), VPA(10), VPA(11), VPA(12), DUMMY4, DUMMY2$
        IF STNO <> STNR THEN
                WHILE NOT EOF(1) AND STNR <> STNO
                        INPUT #1, STNO, DUMMY1, DUMMY2, DUMMY3, VPA(1), VPA(2), VPA(3), VPA(4), VPA(5), VPA(6), VPA(7), VPA(8), VPA(9), VPA(10), VPA(11), VPA(12), DUMMY4, DUMMY2$
                WEND
        END IF
CLOSE #1
IF STNO = -999 THEN
        INPUT "RECORD NUMBER NOT IN FILE PAR05 (VPA in mbar)!  CONTINUE (Y/N)"; VPAMIS$
        IF VPAMIS$ = "n" OR VPAMIS$ = "N" THEN END
ELSE
        PRINT "RHA :";
        FOR MONTH = 1 TO 12
                TMEAN = (TMAX(MONTH) + TMIN(MONTH)) / 2
                TMEAN(MONTH) = TMEAN
                SVAP = 6.11 * EXP(17.4 * TMEAN(MONTH) / (239 + TMEAN(MONTH)))
                SVAP(MONTH) = SVAP
                RHA = VPA(MONTH) / SVAP(MONTH)
                RHA(MONTH) = INT(RHA * 100) / 100
                PRINT USING "###.##"; RHA(MONTH);
                ' PRINT VPA(MONTH);
        NEXT MONTH
END IF
'
OPEN "PAR07" FOR INPUT AS #1
INPUT #1, STNO, DUMMY1, DUMMY2, DUMMY3, u(1), u(2), u(3), u(4), u(5), u(6), u(7), u(8), u(9), u(10), u(11), u(12), DUMMY4, DUMMY2$
        IF STNO <> STNR THEN
                WHILE NOT EOF(1) AND STNR <> STNO
                        INPUT #1, STNO, DUMMY1, DUMMY2, DUMMY3, u(1), u(2), u(3), u(4), u(5), u(6), u(7), u(8), u(9), u(10), u(11), u(12), DUMMY4, DUMMY2$
                WEND
        END IF
CLOSE #1
IF STNO = -999 THEN
        INPUT "RECORD NUMBER NOT IN FILE PAR07 (WIND SPEED in m/s)!  CONTINUE (Y/N)"; WINDMIS$
        IF WINDMIS$ = "n" OR WINDMIS$ = "N" THEN END
ELSE
        PRINT "WIND:";
        FOR x = 1 TO 12
                PRINT USING "###.##"; u(x);
        NEXT x
END IF
'
OPEN "PAR08" FOR INPUT AS #1
INPUT #1, STNO, DUMMY1, DUMMY2, DUMMY3, SUNH(1), SUNH(2), SUNH(3), SUNH(4), SUNH(5), SUNH(6), SUNH(7), SUNH(8), SUNH(9), SUNH(10), SUNH(11), SUNH(12), DUMMY4, DUMMY2$
        IF STNO <> STNR THEN
                WHILE NOT EOF(1) AND STNR <> STNO
                        INPUT #1, STNO, DUMMY1, DUMMY2, DUMMY3, SUNH(1), SUNH(2), SUNH(3), SUNH(4), SUNH(5), SUNH(6), SUNH(7), SUNH(8), SUNH(9), SUNH(10), SUNH(11), SUNH(12), DUMMY4, DUMMY2$
                WEND
        END IF
CLOSE #1
IF STNO = -999 THEN
        INPUT "RECORD NUMBER NOT IN FILE PAR08 (SUNH in % of DL)!  CONTINUE (Y/N)"; SUNHMIS$
        IF SUNHMIS$ = "n" OR SUNHMIS$ = "N" THEN END
ELSE
        PRINT "SUNH:";
        '
        ' ** Percent sunhours must be converted to real sunhours by **
        ' ** multiplying by the equivalent day length in hours (DL(MONTH)) **
        ' ** Calculate daylength (DL(MONTH)) as described in LUSA-text **
        '
        SUMMONTH = 0
        FOR MONTH = 1 TO 12
                SUMMONTH = SUMMONTH + LOM(MONTH)
                DAY = SUMMONTH - 15
                DEC = -23.45 * COS(2 * PI * (DAY + 10) / 365)
                SSIN = SIN(LAT * RAD) * SIN(DEC * RAD)
                CCOS = COS(LAT * RAD) * COS(DEC * RAD)
                SSCC = SSIN / CCOS
                DL = 12 * (PI + 2 * FNASN(SSCC)) / PI
                DL(MONTH) = DL
                SUNNEW = SUNH(MONTH) * DL(MONTH) / 100
                SUNH(MONTH) = SUNNEW
                PRINT USING "###.##"; SUNH(MONTH);
        NEXT MONTH
END IF
PRINT
'                       **************************
'                       ** PENMAN a la DRIESSEN **
'                       **    21 January 1993   **
'                       **************************
'
' For all MONTHs in the year calculate GAMMA, DELTA, EXTRAterrestrial
' radiation, CANopy level RADiation, longwave losses (LWLOSS), net
' absorbed radiation (NARAD), evaporative demand of the atmosphere (EAA)
' and at canopy level (EAC).
'
'
SUMMONTH = 0
FOR MONTH = 1 TO 12
'
        ' ** Calculate daylength (DL) as described in LUSA-text **
        '
        SUMMONTH = SUMMONTH + LOM(MONTH)
        DAY = SUMMONTH - 15
        DEC = -23.45 * COS(2 * PI * (DAY + 10) / 365)
        SSIN = SIN(LAT * RAD) * SIN(DEC * RAD)
        CCOS = COS(LAT * RAD) * COS(DEC * RAD)
        SSCC = SSIN / CCOS
        '
        ' ** Calculate GAMMA from barometric pressure and temperature **
        '
        BARPRESS = 1013 * EXP(-.034 * ELEVATION / (TMEAN(MONTH) + 273))
        GAMMA = BARPRESS * PSYCHRO ' psychrometric constant in mbar/Celsius
        '
        ' ** Calculate DELTA from SVAP and temperature **
        '
        SVAP = 6.11 * EXP(17.4 * TMEAN(MONTH) / (239 + TMEAN(MONTH))) ' Equation 6.22.3
        DELTA = 239 * 17.4 * SVAP / (TMEAN(MONTH) + 239) ^ 2  ' in mbar/Celsius
        '
        ' ** Calculate extraterrestrial radiation (EXTRA) **
        '
        RDN = SSIN + 24 * CCOS * (1 - (SSCC) ^ 2) ^ .5 / (DL(MONTH) * PI)
        EXTRA = SC * RDN * (1 + .033 * COS(2 * PI * DAY) / 365) ' Equation 8.5
        EXTRA = EXTRA * 3600 * DL(MONTH) 'in J/m2/d
        '
        ' ** Calculate radiation at canopy level (CANRAD) **
        '
        AA = .29 * COS(RAD * LAT)
        BB = .52
        TRANS = AA + BB * SUNH(MONTH) / DL(MONTH)
        CANRAD = EXTRA * TRANS ' See Equation 8.6
        '
        ' ** Calculate long wave radiation losses (LWLOSS) **
        '
        VPA = SVAP * RHA(MONTH)
        LWLOSS = BOLTZ * (TMEAN(MONTH) + 273) ^ 4 * (.56 - SQR(VPA) * .079) * (.1 + .9 * SUNH(MONTH) / DL(MONTH))
        ' in J/m2/d according to Brunt (1932)
        '
        ' ** Calculate the net absorbed radiation (NARAD, in mm/m2/d) **
        '
        NARADWATER = (CANRAD * (1 - REFLWATER) - LWLOSS) / LATHEAT
        ' NARADSOIL = (CANRAD * (1 - REFLSOIL) - LWLOSS) / LATHEAT
        NARADCROP = (CANRAD * (1 - REFLCROP) - LWLOSS) / LATHEAT
        '
        ' ** Calculate evaporative demand of the atmosphere (EAA in mm/d) **
        '
        TDIF = (TMAX(MONTH) - TMIN(MONTH))
        BA = (TDIF - 12) / 4
        IF BA < 0 THEN
                BA = 0
        ELSEIF BA > 1 THEN
                BA = 1
        END IF
        BU = .54 + .35 * BA
        '
        VPDEF = SVAP * (1 - RHA(MONTH)) ' VPDEF = SVAP - VPA
        '
        EAA = .26 * VPDEF * (.5 + BU * u(MONTH))
        EAC = .26 * VPDEF * (1 + BU * u(MONTH))
        '
        ' *** PENMAN FORMULAS (1948) ***
        '
        E0 = (DELTA * NARADWATER + GAMMA * EAA) / (DELTA + GAMMA)
        ET0 = (DELTA * NARADCROP + GAMMA * EAC) / (DELTA + GAMMA)
        '
        E0(MONTH) = INT(E0 * 100) / 1000 ' potential rate of evaporation in cm/d
        ET0(MONTH) = INT(ET0 * 100) / 1000 ' potential rate of evapotranspiration in cm/d
NEXT MONTH

'
' *****************************************************************
' * Convert monthly data in array to daily values in PS123 format *                                                       **
' *****************************************************************
'
' Interpolation between (MONTH)-values read from file
'
FOR MONTH = 1 TO 12
        '
        ' There are not more than 12 months and not less than 1
        '
        IF MONTH = 1 THEN
                MMINONE = 12
        ELSE
                MMINONE = MONTH - 1
        END IF
        '
        IF MONTH = 12 THEN
                MPLUSONE = 1
        ELSE
                MPLUSONE = MONTH + 1
        END IF
        '
        ' Values from file hold for the 15th day in the month. First, we
        ' interpolate over the first 15 days between the values for MONTH
        ' and for MONTH - 1 (= MMINONE). The running day number is retained.
        '
        FOR DAY = 1 TO 15
                RUNNUM = RUNNUM + 1
                GTMAX(RUNNUM) = TMAX(MMINONE) + (TMAX(MONTH) - TMAX(MMINONE)) * (DAY + (LOM(MMINONE) - 15)) / LOM(MMINONE)
                GTMIN(RUNNUM) = TMIN(MMINONE) + (TMIN(MONTH) - TMIN(MMINONE)) * (DAY + (LOM(MMINONE) - 15)) / LOM(MMINONE)
                GPREC(RUNNUM) = PREC(MMINONE) / LOM(MMINONE) + (PREC(MONTH) / LOM(MONTH) - PREC(MMINONE) / LOM(MMINONE)) * (DAY + (LOM(MMINONE) - 15)) / LOM(MMINONE)
                GRHA(RUNNUM) = RHA(MMINONE) + (RHA(MONTH) - RHA(MMINONE)) * (DAY + (LOM(MMINONE) - 15)) / LOM(MMINONE)
                GE0(RUNNUM) = E0(MMINONE) + (E0(MONTH) - E0(MMINONE)) * (DAY + (LOM(MMINONE) - 15)) / LOM(MMINONE)
                GSUNH(RUNNUM) = SUNH(MMINONE) + (SUNH(MONTH) - SUNH(MMINONE)) * (DAY + (LOM(MMINONE) - 15)) / LOM(MMINONE)
                GET0(RUNNUM) = ET0(MMINONE) + (ET0(MONTH) - ET0(MMINONE)) * (DAY + (LOM(MMINONE) - 15)) / LOM(MMINONE)
        NEXT DAY
        '
        ' Interpolation over the 15th day till the last day in the month
        ' (= LOM(MONTH)) considers the values for MONTH and MPLUSONE.
        '
        FOR DAY = 1 TO (LOM(MONTH) - 15)
                RUNNUM = RUNNUM + 1
                GTMAX(RUNNUM) = TMAX(MONTH) + (TMAX(MPLUSONE) - TMAX(MONTH)) * DAY / LOM(MONTH)
                GTMIN(RUNNUM) = TMIN(MONTH) + (TMIN(MPLUSONE) - TMIN(MONTH)) * DAY / LOM(MONTH)
                GPREC(RUNNUM) = PREC(MONTH) / LOM(MONTH) + (PREC(MPLUSONE) / LOM(MPLUSONE) - PREC(MONTH) / LOM(MONTH)) * DAY / LOM(MONTH)
                GRHA(RUNNUM) = RHA(MONTH) + (RHA(MPLUSONE) - RHA(MONTH)) * DAY / LOM(MONTH)
                GE0(RUNNUM) = E0(MONTH) + (E0(MPLUSONE) - E0(MONTH)) * DAY / LOM(MONTH)
                GSUNH(RUNNUM) = SUNH(MONTH) + (SUNH(MPLUSONE) - SUNH(MONTH)) * DAY / LOM(MONTH)
                GET0(RUNNUM) = ET0(MONTH) + (ET0(MPLUSONE) - ET0(MONTH)) * DAY / LOM(MONTH)
        NEXT DAY
NEXT MONTH
'
PRINT
' PRINT "STATION NAME IS: "; SITELABEL$
PRINT
INPUT "   SPECIFY FILE TO STORE DAILY DATA (drv:name.ext): "; CONV$
'
OPEN CONV$ FOR OUTPUT AS #1
WRITE #1, SITELABEL$, LAT, LON, ELEVATION
FOR DAY = 1 TO 365
        GE0(DAY) = INT(GE0(DAY) * 1000) / 1000
        IF GE0(DAY) < .01 THEN GE0(DAY) = .01
        GET0(DAY) = INT(GET0(DAY) * 1000) / 1000
        IF GET0(DAY) < .01 THEN GET0(DAY) = .01
        WRITE #1, DAY, INT(GTMAX(DAY) * 100) / 100, INT(GTMIN(DAY) * 100) / 100, INT(GPREC(DAY) * 1000) / 1000, INT(GRHA(DAY) * 100) / 100, GE0(DAY), INT(GSUNH(DAY) * 10) / 10, GET0(DAY)
NEXT DAY
CLOSE #1
'
END

